#!/usr/bin/python

import gtk
import gtk.glade
import gconf

class GConfExample:
	# signals
	def do_exit (self, window):
		gtk.main_quit ()
	def new_background (self, client, cnxn_id, entry, user_data):
		image = client.get_string (
			"/desktop/gnome/background/picture_filename")
		pixbuf = gtk.gdk.pixbuf_new_from_file_at_size (image, 300, 300)
		self.entry.set_text (image)
		self.image.set_from_pixbuf (pixbuf)

	# initilisation
	def __init__ (self):
		xml = gtk.glade.XML ('gconf-example.glade', None, None)
		client = gconf.client_get_default ()
		
		self.image = xml.get_widget ('preview_image')
		self.entry = xml.get_widget ('image_name')
		
		xml.signal_autoconnect (self)
		client.add_dir ("/desktop/gnome/background",
				gconf.CLIENT_PRELOAD_NONE)
		client.notify_add ("/desktop/gnome/background/picture_filename",
				self.new_background)
		
		self.new_background (client, None, None, None)
		xml.get_widget ('window').show_all ()

if __name__ == '__main__':
	GConfExample ()
	gtk.main ()
