#!/usr/bin/env python2.3

import os,sys

# Load the database interface
from pyPgSQL import PgSQL

# Our DB query. Returns two columns.
query = """
SELECT DISTINCT
    id,
    customer_code,
    issue_week,
    first_run_week,
    last_run_week
FROM booking
WHERE     issue_week < '2004-02-01'
      AND issue_week > '2004-01-01'
ORDER BY customer_code, issue_week
"""

# connect to the DB using default parameters. With PostgreSQL
# this will use the local UNIX socket, performing authentication
# by local user ID.
conn = PgSQL.connect()

# Create a cursor on the connection. Cursors are what we actually
# use to execute the query and retrieve results.
curs = conn.cursor()

# run the query. We're cheating and hardcoding the dates into the
# query to avoid bringing date calculations into the program, so we
# don't need to pass any params to be substituted.
# in this case, we skip any entries with NULL "last_run_week" values.
# (Yes, I know we we could do that in the query; that's not the point).
curs.execute(query)

for row in curs.fetchall():
    if not row.last_run_week:
        continue
    print "%8i %-6s %10s %10s %10s" % ( row.id,
                        row.customer_code,
                        row.issue_week.Format("%F"),
                        row.first_run_week.Format("%F"),
                        row.last_run_week.Format("%F"),
                        )
