# Use sensible division, where int/int -> float
from __future__ import division

# Reportlab imports are messy
from reportlab.pdfgen import canvas
from reportlab.lib.units import cm
from reportlab.lib.pagesizes import A4
from reportlab.lib.utils import ImageReader

# Make the canvas.
c = canvas.Canvas("/tmp/sample.pdf")
# Save paper size
width, height = A4
# Note: logo is a CMYK TIFF. Anything handled by the PIL is supported.
img = ImageReader("images/logo.tif")
x,y = img.getSize()

scaled_height = y*width/x
c.drawImage(img, 0, height/2, width, scaled_height)

c.showPage()
c.save()
