#!/usr/bin/env python2.3

# Imports common to almost all Python programs, providing access to
# interpreter features and OS capabilities.
import os,sys

# Load the bits of Platypus that we'll be using
from reportlab.platypus import SimpleDocTemplate, Paragraph, Spacer, Table, TableStyle

# And import a few utility variables
from reportlab.lib.units import cm
from reportlab.lib.pagesizes import A4
from reportlab.lib import colors

# Assemble our sample data table. Normally this information
# would come from a database or other external source;
# pretend it is.
#   Company name            Num ordered     Failure rate
input_data = [
    ["Acme Rocket Co",      500,            0.9],
    ["Acme Vehicles, Inc",  7,              1.0],
    ["Acme Foods",          5000000,        0.2],
    ["Real Plastic",        1,              1.0],
    ["Evil Media",          12,             0.0],
    ["Fizzy Dice",          8,              0.0],
    ["Acme Aero",           1,              1.0],
    ["Acme Arms & Armour",  30,             0.85]
    ] * 20
# The "* 20" repeats the data 20 times, to fill out the table and
# stop me having to type a huge amount.

# Have we been passed exactly one argument (remember, sys.argv[0]
# is the executable name)?
if len(sys.argv) == 2:
    # Set the output file name to the first command line argument
    outfile = sys.argv[1]
else:
    # Exit messily, returning a usage message. Normally you'd
    # use print and sys.exit() instead, but we don't care right
    # now if the user sees a traceback.
    raise Exception,"Usage: %s output_file.pdf" % sys.argv[0]

# Create the Platypus document instance we'll be using to draw
# everything and create the PDF. We don't need to do much to it
# in this case. Note that we pass a file _name_, a simple string,
# here. We could pass a file object, too, and ReportLab would
# figure it out.
# We're letting the document template make all the layout decisions
# in this simple example.
doc = SimpleDocTemplate(outfile)

# Make an array to hold the objects to be rendered onto 
# the canvas
elements = []

# Make another array to hold the data we plan to put
# in the table. We pre-fill it with the first row,
# which contains the column headings.
table_data = [["Company Name", "Num Ordered", "Fail Rate"]]

# Iterate over the "input" data, adding it to the dict
# of data to be sent to the table renderer.
# You might do formatting, checking, etc on the row
# data as you read it inside this loop.
for row in input_data:
    table_data.append(row)

# Construct the Platypus table object that'll render it all,
# feeding it the table_data array. We say nothing about
# formatting, so it'll make its own decisions - usually effective,
# but unimpressive.
t = Table(table_data,
          repeatRows=1      # This causes it to repeat the headings
                            # on each new page.
          )

# Add the table to the list of elements we'll be asking Platypus
# to draw onto the page.
elements.append(t)

# Render the page to the canvas and save it.
doc.build(elements)
