#!/usr/bin/env python2.3

from reportlab.pdfgen import canvas
from reportlab.lib.units import cm
from reportlab.lib.pagesizes import A4

# Create a canvas, specifying where
# it is to be saved when complete.
ca = canvas.Canvas("/tmp/hello.pdf")

# Save the page dimensions for later use.
page_width, page_height = A4

# Draw "Hello, World" horizontally centred
# on the canvas, with the _top_ of the text
# 1cm below the page top. Remember text is
# drawn from the baseline.

ca.setFont("Times-Bold", 36)
ca.drawCentredString(page_width / 2, page_height - 1*cm - 36 , "Hello, World")

# Draw the page to the canvas
ca.showPage()

# and save the canvas to the file specified at creation time
ca.save()
